package ru.yandex.direct.grid.processing.util.findandreplace;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;

import static org.apache.commons.lang3.StringUtils.containsIgnoreCase;

/**
 * Удаление значения
 *
 * <p>
 * Может работать в двух режимах:
 * 1. Если searchText == null удаление происходит для любой входящей строки
 * 2. Если searchText != null удаление происходит для входящий строки, содержащей searchText
 */
@ParametersAreNonnullByDefault
public class DeleteWhenContainsRule implements ReplaceRule {

    private final String searchText;
    private final Boolean caseSensitive;

    public DeleteWhenContainsRule(@Nullable String searchText, Boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
    }

    @Nullable
    @Override
    public String apply(String value) {
        if (searchText == null || value != null && contains(value, searchText, caseSensitive)) {
            return null;
        } else {
            return value;
        }
    }

    private static boolean contains(String text, String search, Boolean caseSensitive) {
        if (caseSensitive) {
            return text.contains(search);
        } else {
            return containsIgnoreCase(text, search);
        }
    }
}
