package ru.yandex.direct.grid.processing.util.findandreplace;

import java.util.regex.Pattern;

import javax.annotation.Nullable;

import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;

public class FindAndReplaceRule implements ReplaceRule {
    private final String find;
    private final String replace;
    private final boolean caseSensitive;

    public FindAndReplaceRule(String find, String replace, boolean caseSensitive) {
        this.find = find;
        this.replace = replace;
        this.caseSensitive = caseSensitive;
    }

    @Nullable
    @Override
    public String apply(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (caseSensitive) {
            return value.replace(find, replace);
        } else {
            return replaceIgnoreCase(value, find, replace);
        }
    }

    private static String replaceIgnoreCase(String source, String find, String replace) {
        return source.replaceAll("(?i)" + Pattern.quote(find), replace);
    }
}
