package ru.yandex.direct.grid.processing.util.findandreplace;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.findandreplace.FindAndReplaceParams;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;

@ParametersAreNonnullByDefault
public class ReplaceRuleHelper {

    public static ReplaceRule getReplaceRule(FindAndReplaceParams<?> findAndReplaceParams) {
        if (findAndReplaceParams.getSearchText().isEmpty()) {
            return new AlwaysReplaceRule(findAndReplaceParams.getChangeText(), findAndReplaceParams.getChangeMode());
        }

        return new PatternReplaceRule(findAndReplaceParams);
    }
}
