package ru.yandex.direct.grid.processing.util.findandreplace;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.findandreplace.ChangeMode;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;

import static org.apache.commons.lang3.StringUtils.containsIgnoreCase;

/**
 * Заменяет целиком исходную строку на replaceText или дописывает в начало/в конец в зависимости от changeMode
 * <p>
 * Может работать в двух режимах:
 * 1. Если searchText == null модификация происходит для любой входящей строки
 * 2. Если searchText != null модификация происходит для входящий строки, содержащей searchText
 */
@ParametersAreNonnullByDefault
public class ReplaceWhenContainsRule implements ReplaceRule {
    private final String searchText;
    private final AlwaysReplaceRule alwaysReplaceRule;
    private final Boolean caseSensitive;

    public ReplaceWhenContainsRule(@Nullable String searchText, String replaceText, ChangeMode changeMode,
                                   Boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
        this.alwaysReplaceRule = new AlwaysReplaceRule(replaceText, changeMode);
    }

    @Override
    public String apply(String value) {
        if (searchText == null || value != null && contains(value, searchText, caseSensitive)) {
            return alwaysReplaceRule.apply(value);
        } else {
            return value;
        }
    }

    private static boolean contains(String text, String search, Boolean caseSensitive) {
        if (caseSensitive) {
            return text.contains(search);
        } else {
            return containsIgnoreCase(text, search);
        }
    }
}
