package ru.yandex.direct.configuration;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.hourglass.HourglassProperties;
import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.ydb.schedulerinstances.YdbScheduleInstancesRepository;
import ru.yandex.direct.hourglass.ydb.storage.IdHashSha256Generator;
import ru.yandex.direct.hourglass.ydb.storage.YdbStorageImpl;
import ru.yandex.direct.ydb.YdbPath;
import ru.yandex.direct.ydb.client.YdbSessionProperties;

import static ru.yandex.direct.configuration.DirectHourglassConfiguration.VERSION_BEAN_NAME;
import static ru.yandex.direct.configuration.YdbConfiguration.HOURGLASS_YDB_PATH_BEAN;
import static ru.yandex.direct.configuration.YdbConfiguration.HOURGLASS_YDB_SESSION_PROPERTIES_BEAN;
import static ru.yandex.direct.configuration.YdbConfiguration.HOURGLASS_YDB_TABLE_CLIENT_BEAN;

@Lazy
@Configuration
@Import({
        DirectHourglassConfiguration.class,
        YdbConfiguration.class
})
public class HourglassYdbStorageConfiguration {

    @Bean
    public YdbStorageImpl ydbStorageImpl(
            @Qualifier(HOURGLASS_YDB_TABLE_CLIENT_BEAN) TableClient tableClient,
            @Qualifier(HOURGLASS_YDB_PATH_BEAN) YdbPath ydbPath,
            @Qualifier(HOURGLASS_YDB_SESSION_PROPERTIES_BEAN) YdbSessionProperties hourglassYdbProperties,
            HourglassProperties hourglassProperties, InstanceId instanceId,
            @Qualifier(VERSION_BEAN_NAME) String version
    ) {
        return new YdbStorageImpl(tableClient, ydbPath, hourglassYdbProperties, hourglassProperties, instanceId,
                version,
                new IdHashSha256Generator());
    }

    @Bean
    public YdbScheduleInstancesRepository ydbSchedulerInstancesRepository(
            @Qualifier(HOURGLASS_YDB_TABLE_CLIENT_BEAN) TableClient tableClient,
            @Qualifier(HOURGLASS_YDB_PATH_BEAN) YdbPath ydbPath,
            HourglassProperties hourglassProperties
    ) {
        return YdbScheduleInstancesRepository.builder(tableClient, ydbPath)
                .withHeartbeatExpiration(hourglassProperties.getSchedulerHeartbeatExpiration())
                .withLeaderVotingLowerBound(hourglassProperties.getLeaderVotingLowerBound())
                .build();
    }
}
