package ru.yandex.direct.tracing

import ru.yandex.direct.scheduler.support.BaseDirectJob
import ru.yandex.direct.scheduler.support.DirectParameterizedJob
import ru.yandex.direct.scheduler.support.DirectShardedJob


fun formatTags(originalJob: BaseDirectJob): List<String> {
    val tags = mutableListOf<String>()
    if (DirectShardedJob.isShardedJobClass(originalJob.javaClass)) {
        val shard = (originalJob as DirectShardedJob).shard
        tags.add("shard_$shard")
    } else if (originalJob is DirectParameterizedJob<*>) {
        val param = originalJob.param
        tags.add("param_$param")
    }
    return tags
}
