package ru.yandex.direct.hrefs.parameterizer;

import java.util.Map;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;

import static java.util.Map.entry;

/**
 * Аналог perl https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/Campaign/Types.pm?rev=7482122#L653
 **/
public class CampaignTypeMapper {
    private static final Map<CampaignType, String> campTypeMapping = Map.ofEntries(
            entry(CampaignType.TEXT, "type1"),
            entry(CampaignType.MOBILE_CONTENT, "type2"),
            entry(CampaignType.DYNAMIC, "type3"),
            entry(CampaignType.PERFORMANCE, "type4"),
            entry(CampaignType.GEO, "type5"),
            entry(CampaignType.MCBANNER, "type6"),
            entry(CampaignType.CPM_BANNER, "type7"),
            entry(CampaignType.CPM_DEALS, "type8"),
            entry(CampaignType.INTERNAL_DISTRIB, "type9"),
            entry(CampaignType.INTERNAL_FREE, "type10"),
            entry(CampaignType.INTERNAL_AUTOBUDGET, "type11"),
            entry(CampaignType.CPM_YNDX_FRONTPAGE, "type12"),
            entry(CampaignType.CONTENT_PROMOTION, "type13"),
            entry(CampaignType.CPM_PRICE, "type14"));

    public String map(CampaignType campaignType) {
        return campTypeMapping.getOrDefault(campaignType, "");
    }
}
