package ru.yandex.direct.hrefs.parameterizer;

import java.util.List;

/**
 * Табличка с известными нам параметрами которые можно задавать в УРЛ.
 * ENUM_VALUE(keys), keys - массив названий шаблонов которые можно использовать в урл.
 * Аналог perl https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/Export.pm?rev=7485700#L222
 **/

public enum HrefParameter {
    AD_ID("ad_id", "adid", "banner_id", "bannerid"),
    ADD_PHRASES("addphrases"),
    ADD_PHRASES_TEXT("addphrasestext"),
    AD_GROUP_ID("adgroup_id", "adgroupid"),
    ADTARGET_ID("adtarget_id"),
    ADTARGET_NAME("adtarget_name"),
    ANDROID_ID("android_id", "androidid"),
    ANDROID_ID_LC_SH1("android_id_lc_sh1"),
    CAMPAIGN_ID("campaign_id", "campaignid"),
    CAMPAIGN_NAME("campaign_name", "campaignname"),
    CAMPAIGN_NAME_LAT("campaign_name_lat", "campaignnamelat"),
    CAMPAIGN_TYPE("campaign_type", "campaigntype"),
    CAMPAIGN_CURRENCY("campaign_currency", "campaigncurrency"),
    CAMPAIGN_CURRENCY_CODE("campaign_currency_code", "campaigncurrencycode"),
    CAMPAIGN_COST_TYPE("campaign_cost_type", "campaigncosttype"),
    CAMPAIGN_COST("campaign_cost", "campaigncost"),
    COEF_GOAL_CONTEXT_ID("coef_goal_context_id"),
    CREATIVE_ID("creative_id", "smartbanner_id"),
    DEVICE_TYPE("device_type"),
    GBID("gbid"),
    GOOGLE_AID("google_aid", "googleaid"),
    GOOGLE_AID_LC_SH1("google_aid_lc_sh1"),
    INTEREST_ID("interest_id"),
    IOS_IFA("ios_ifa", "iosifa", "idfa_lc"),
    IDFA_LC_SH1_HEX("idfa_lc_sh1_hex", "idfa_lc_sh1"),
    IDFA_LC_MD5_HEX("idfa_lc_md5_hex", "idfa_lc_md5"),
    KEYWORD("keyword"),
    LOGID("logid"),
    MATCH_TYPE("match_type"),
    MATCHED_KEYWORD("matched_keyword"),
    OFFER_ID("offer_id"),
    PARAM1("param1"),
    PARAM2("param2"),
    PHRASE_ID("phrase_id", "phraseid"),
    POSITION("position"),
    POSITION_TYPE("position_type"),
    REGION_ID("region_id"),
    REGION_NAME("region_name"),
    RETARGETING_ID("retargeting_id"),
    SOURCE("source"),
    SOURCE_TYPE("source_type"),
    TRACKID("trackid"),
    OAID("oaid"),
    OAID_LC("oaid_lc"),
    OAID_LC_SH1_HEX("oaid_lc_sh1_hex", "oaid_lc_sh1"),
    OAID_LC_MD5_HEX("oaid_lc_md5_hex", "oaid_lc_md5"),
    CLIENTIP("client_ip"),
    USER_AGENT("user_agent"),
    DEVICE_LANG("device_lang"),
    YCLID("yclid")
    ;

    private final List<String> keys;

    HrefParameter(String key) {
        this.keys = List.of(key);
    }

    HrefParameter(String... keys) {
        this.keys = List.of(keys);
    }

    public List<String> getKeys() {
        return keys;
    }
}
