package ru.yandex.direct.internaltools.core.annotations.enrich;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Аннотация, определяющая, что проаннотированный класс является поставщиком дополнительных данных для табличного вывода
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface EnrichFetcher {
    /**
     * Ключ, по которому получаются данные в методе fetch проаннотированного класса
     */
    InternalToolDetailKey value();
}
