package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода даты. Игнорируется для всех полей, кроме полей с типом
 * LocalDate, отчеменных как @Input
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Date {
    /**
     * Значение поля по умолчанию в виде ISO-строки. Не может быть использовано совместно с today
     */
    String defaultValue() default "";

    /**
     * Задать значение по умолчанию как текущую дату. Не может быть использовано совместно с defaultValue
     */
    boolean today() default false;
}
