package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода даты и времени. Игнорируется для всех полей, кроме полей с типом
 * LocalDateTime, отчеменных как @Input
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DateTime {
    /**
     * Значение поля по умолчанию в виде ISO-строки. Не может быть использовано совместно с now
     */
    String defaultValue() default "";

    /**
     * Задать значение по умолчанию как время запроса отчета. Не может быть использовано совместно с defaultValue
     */
    boolean now() default false;

    /**
     * Округлить до начала дня и сдвинуть. Используется только совместно с now.
     * 1 соответствует началу следующего дня, 2 - послезавтра...
     * -1 соответствует началу текущего дня, -2 - вчера...
     * 0 - текущее время
     */
    int dayShift() default 0;
}
