package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для определения того, к какой группе ввода принадлежит поле
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Group {
    /**
     * Имя группы, будет отображаться над всеми полями
     */
    String name();

    /**
     * Приоритет группы. Чем он больше, тем выше в интерфейсе будет группа. Внутри одного приоритета группы сортируются
     * по именам
     */
    int priority() default 0;
}
