package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

/**
 * Аннотация, сообщающая о том, что поле должно быть использовано при генерации интерфейса как одно из полей формы
 * ввода.
 * <p>
 * Аннотация может быть использована только на публичное поле или поле с геттером.
 * Поддерживает по умолчанию следующие типы данных:
 * - Boolean и boolean (использует input с типом checkbox, который может быть настроен с помощью аннотации @CheckBox (не обязательно))
 * - Long и long (использует input с типом number, который может быть настроен с помощью аннотации @Number или @NumericId (не обязательно))
 * - LocalDate (использует input с типом date, который может быть настроен с помощью аннотации @Date (не обязательно))
 * - LocalDate (использует input с типом datetime, который может быть настроен с помощью аннотации @DateTime (не обязательно))
 * - String (использует input с типом text, который может быть настроен с помощью аннотации @Text (не обязательно),
 * также может использовать textarea при аннотировании @TextArea или селекта при использовании @Select)
 * - Integer и int (только для ввода шарда, обязательно использование аннотации @ShardSelect)
 * - Enum (использует селект)
 * - Set<Enum>, Set<String> и Set<Long> (для выбора нескольких элементов, обязательно использование аннотации @MultipleSelect)
 * - byte[] (только для загрузки файла, обязательно использование аннотации @File)
 * <p>
 * Также можно использовать значение любого типа в спрятанном поле ввода с помощью аннотации @Hidden
 * <p>
 * TODO(bzzzz): хочется еще добавить поддержку параметров типа List<String> и List<Long>
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Input {
    /**
     * Короткое человекочитаемое название поля.
     * <p>
     * Это именно то название, которое увидит пользователь. Имя поля в форме будет взято из имени проаннотированного
     * поля в классе или из значения аннотации com.fasterxml.jackson.annotation.JsonProperty
     */
    String label();

    /**
     * Расширенное пояснение о назначении поля, если это необходимо. Можно использовать HTML-теги.
     */
    String description() default "";

    /**
     * Если поле необязательно к заполнению, установить в false.
     * <p>
     * required == true гарантирует нам, что фронт не отправит пустое значение для этого поля
     */
    boolean required() default true;

    Class<? extends InternalToolInputPreProcessor>[] processors() default {};
}
