package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для поля с выбором нескольких элементов.
 * Игнорируется для всех полей, кроме полей с типом Set<Enum>, Set<String>, Set<Long>
 * Если тип элементов Set'а это Enum, то вместо метода choices {@link MultipleSelect#choices} значения берутся из Enum'а
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MultipleSelect {

    /**
     * Набор значений. Для Enum'а не нужен
     */
    String[] choices() default {};

    /**
     * Отметить, что у селекта есть связанный препроцессинг, поэтому ему можно не иметь вариантов выбора
     * значений при создании
     */
    boolean preprocessed() default false;

    /**
     * Значения по умолчанию
     */
    String[] defaultValues() default {};
}
