package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода c типом number. Игнорируется для всех полей, кроме полей с типом
 * long и Long, отчеменных как @Input
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Number {
    /**
     * Значение поля по-умолчанию
     */
    long defaultValue() default 0L;

    /**
     * Минимальное допустимое значение поля
     */
    long minValue() default Long.MIN_VALUE;

    /**
     * Максимальное допустимое значение поля
     */
    long maxValue() default Long.MAX_VALUE;
}
