package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода идентификаторов. Игнорируется для всех полей, кроме полей с типом
 * long и Long, отчеменных как @Input. Также игнорируется, если поле уже было проаннотировано как @Number
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface NumericId {
    /**
     * Значение поля по-умолчанию
     */
    long defaultValue() default Long.MIN_VALUE;

    /**
     * Может ли идентификатор быть нулем
     */
    boolean canBeZero() default false;
}
