package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для поля с выбором элементов. Игнорируется для всех полей, кроме полей с типом String, отчеменных как @Input
 * Поля с типом ENUM помечать не нужно, они автоматически становятся селектами
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Select {
    /**
     * Набор значений
     */
    String[] choices() default {};

    /**
     * Отметить, что у селекта есть связанный препроцессинг, поэтому ему можно не иметь вариантов выбора
     * значений при создании
     */
    boolean preprocessed() default false;

    /**
     * Значение по умолчанию
     */
    String defaultValue() default "";
}
