package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода c типом text. Игнорируется для всех полей, кроме полей с типом
 * String, отчеменных как @Input
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Text {
    /**
     * Длина поля ввода
     */
    int fieldLen() default -1;

    /**
     * Максимальная длина задаваемого значения
     */
    int valueMaxLen() default -1;

    /**
     * Значение по умолчанию
     */
    String defaultValue() default "";
}
