package ru.yandex.direct.internaltools.core.annotations.input;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для описания параметров поля ввода c типом textarea. Игнорируется для всех полей, кроме полей с типом
 * String, отчеменных как @Input
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface TextArea {
    /**
     * Количество рядов в поле ввода
     */
    int rows() default -1;

    /**
     * Количество колонок в поле ввода
     */
    int columns() default -1;

    /**
     * Значение по умолчанию
     */
    String defaultValue() default "";
}
