package ru.yandex.direct.internaltools.core.annotations.output;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Аннотация для того, чтобы отметить поле, для которого в ответ нужно добавить информацию для его красивого
 * отображения на фронтенде.
 * <p>
 * Нужно следить за тем, чтобы тип аннотированного поля поддерживался объектом
 * {@link ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher}, который будет непосредственно
 * заниматься добавлением данных
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Enrich {
    /**
     * Тип ключа для обогащения данных
     */
    InternalToolDetailKey value();
}
