package ru.yandex.direct.internaltools.core.annotations.tool;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;

/**
 * Дополнительная аннотация для описания внутреннего инструмента.
 * Позволяет задать роли пользователей, которые могут воспользоваться инструментом. Если аннотация не задана,
 * доступ дается только суперам, разработчикам и суперридерам.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface AccessGroup {
    InternalToolAccessRole[] value();
}
