package ru.yandex.direct.internaltools.core.annotations.tool;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.internaltools.core.enums.InternalToolAction;

/**
 * Дополнительная аннотация для описания внутреннего инструмента.
 * Позволяет задать надпись на кнопке действия в пользовательском интерфейсе. Если аннотация не задана, используется
 * значение ru.yandex.direct.internaltools.core.enums.InternalToolAction.SHOW
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Action {
    InternalToolAction value();
}
