package ru.yandex.direct.internaltools.core.annotations.tool;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;

/**
 * Дополнительная аннотация для описания внутреннего инструмента.
 * Позволяет задать категорию инструмента. Инструменты одной категории отображаются в интерфейсе вместе
 * По умолчанию ru.yandex.direct.internaltools.core.enums.InternalToolCategory.OTHER
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Category {
    InternalToolCategory value();
}
