package ru.yandex.direct.internaltools.core.annotations.tool;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Дополнительная аннотация для описания внутреннего инструмента.
 * Позволяет задать короткие текстовые сообщения с предупреждениями о каких то проблемах. Например о разрывах в данных
 * или неявных зависимостях во вводе. Данные сообщения будут выделены в интерфейсе.
 * <p>
 * По умолчанию предупреждения отсутствуют
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Disclaimers {
    String[] value();
}
