package ru.yandex.direct.internaltools.core.annotations.tool;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.enums.InternalToolType;

/**
 * Аннотация, отмечающая подкласс {@link ru.yandex.direct.internaltools.core.BaseInternalTool} как внутренний
 * инструмент, с которым может взаимодействовать пользователь через стандартный интерфейс. По этой аннотации
 * генерируется стандартное описание инструмента
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface Tool {
    /**
     * Человекочитаемое имя инструмента
     */
    String name();

    /**
     * Метка инструмента. Должна быть уникальна в пределах приложения. Может состоять только из строчных символов
     * латинского алфавита, цифр и знаков подчеркивания
     */
    String label();

    /**
     * Подробное описание инструмента: что он делает, какие проблемы он решает, какие есть подводные камни
     */
    String description();

    /**
     * Тип принимаемых данных. Указывать нужно максимально точно, так как по значению этого поля генерируется их описание
     */
    Class<?> consumes();

    /**
     * Тип инструмента. На текущий момент - это может быть отчет или инструмент меняющий состояние базы данных.
     * В зависимости от типа инструмент можно будет вызвать только GET-запросом или только POST-запросом
     */
    InternalToolType type();

    /**
     * Флаг, сообщающий можно ли по данным, возвращаемым инструментом, построить график
     */
    boolean includeChart() default false;
}
