package ru.yandex.direct.internaltools.core.bootstrap;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichProcessorFactory;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.internaltools.core.exception.InternalToolInitialisationException;

public class InternalToolEnrichProcessorFactoryBootstrap {
    private InternalToolEnrichProcessorFactoryBootstrap() {
    }

    public static InternalToolEnrichProcessorFactory factoryFromFetchers(
            Collection<InternalToolEnrichDataFetcher> fetchers) {
        Map<InternalToolDetailKey, InternalToolEnrichDataFetcher> keysToFetchers =
                new EnumMap<>(InternalToolDetailKey.class);
        for (InternalToolEnrichDataFetcher fetcher : fetchers) {
            EnrichFetcher enrichFetcher = fetcher.getClass().getAnnotation(EnrichFetcher.class);
            if (enrichFetcher == null) {
                throw new InternalToolInitialisationException("We expect fetcher to have an annotation");
            }

            InternalToolDetailKey key = enrichFetcher.value();
            if (keysToFetchers.containsKey(key)) {
                throw new InternalToolInitialisationException("We expect getting unique fetcher for each key");
            }
            keysToFetchers.put(key, fetcher);
        }

        return new InternalToolEnrichProcessorFactory(keysToFetchers);
    }
}
