package ru.yandex.direct.internaltools.core.bootstrap;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.InternalToolProxy;
import ru.yandex.direct.internaltools.core.InternalToolsRegistry;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichProcessorFactory;
import ru.yandex.direct.internaltools.core.exception.InternalToolInitialisationException;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.internaltools.core.bootstrap.InternalToolProxyBootstrap.proxyFromTools;

public class InternalToolsRegistryBootstrap {

    public static InternalToolsRegistry generateRegistry(Collection<BaseInternalTool<?>> internalTools,
                                                         InternalToolEnrichProcessorFactory enrichProcessorFactory,
                                                         List<InternalToolInputPreProcessor<?>> preProcessors,
                                                         FeatureService featureService,
                                                         int shardNum) {
        Map<String, InternalToolProxy<?>> toolsMap =
                generateToolsMap(internalTools, enrichProcessorFactory, preProcessors, shardNum);
        return new InternalToolsRegistry(toolsMap, featureService);
    }

    static Map<String, InternalToolProxy<?>> generateToolsMap(Collection<BaseInternalTool<?>> internalTools,
                                                              InternalToolEnrichProcessorFactory enrichProcessorFactory,
                                                              List<InternalToolInputPreProcessor<?>> preProcessors, int shardNum) {
        HashMap<String, InternalToolProxy<?>> labelToTool = new HashMap<>();
        for (BaseInternalTool<?> internalTool : internalTools) {
            InternalToolProxy<?> proxy = proxyFromTools(internalTool, enrichProcessorFactory, preProcessors, shardNum);
            String label = proxy.getLabel();
            if (labelToTool.containsKey(label)) {
                throw new InternalToolInitialisationException(
                        String.format("Found duplicate tool with label %s", label));
            }
            labelToTool.put(proxy.getLabel(), proxy);
        }
        return labelToTool;
    }
}
