package ru.yandex.direct.internaltools.core.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Результат работы внутреннего инструмента, возвращающего табличные данные
 */
@ParametersAreNonnullByDefault
public class InternalToolMassResult<T> extends InternalToolResult {
    /**
     * Сами табличные данные
     */
    private final List<T> data;
    /**
     * Детали, необходимые для построения красивых описаний объектов в интерфейсе
     */
    private Map<String, InternalToolDetailsData> details;

    public Map<String, InternalToolDetailsData> getDetails() {
        return details;
    }

    public void setDetails(Map<String, InternalToolDetailsData> details) {
        this.details = details;
    }

    public InternalToolMassResult<T> withDetails(Map<String, InternalToolDetailsData> details) {
        this.details = details;
        return this;
    }

    public InternalToolMassResult() {
        data = new ArrayList<>();
    }

    public InternalToolMassResult(Collection<T> data) {
        this.data = new ArrayList<>(data);
    }

    public InternalToolMassResult<T> addItem(T item) {
        data.add(item);
        return this;
    }

    public List<T> getData() {
        return Collections.unmodifiableList(data);
    }
}
