package ru.yandex.direct.internaltools.core.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.user.model.User;


/**
 * Описание объекта, который отдается в details в случае Enrich с категорией InternalToolDetailsCategory.USER
 */
@ParametersAreNonnullByDefault
public class InternalToolUserData {
    private String login;
    private String name;
    private Long uid;
    private Long clientId;


    public InternalToolUserData(String login, String name, Long uid, Long clientId) {
        this.login = login;
        this.name = name;
        this.uid = uid;
        this.clientId = clientId;
    }

    public InternalToolUserData(User user) {
        this.login = user.getLogin();
        this.name = user.getFio();
        this.uid = user.getUid();
        this.clientId = user.getClientId().asLong();

    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
