package ru.yandex.direct.internaltools.core.enrich;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Интерфейс объекта, который получает данные для расширенного представления сущностей на фронте
 */
@ParametersAreNonnullByDefault
public interface InternalToolEnrichDataFetcher<T, Y> {
    /**
     * Получить информацию по представлению объектов с переданными идентификаторами. Список идентификаторов может быть
     * пустым, ответ должен быть сериализуемым
     */
    Map<T, Y> fetch(Collection<T> keys);
}
