package ru.yandex.direct.internaltools.core.enrich;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.container.InternalToolDetailsData;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailsCategory;
import ru.yandex.direct.internaltools.core.util.InternalToolFieldExtractor;

@ParametersAreNonnullByDefault
public class InternalToolEnrichProcessor {
    private final InternalToolDetailsCategory category;
    private final String fieldName;
    private final InternalToolFieldExtractor extractor;
    private final InternalToolEnrichDataFetcher fetcher;

    InternalToolEnrichProcessor(String fieldName, InternalToolFieldExtractor extractor,
                                InternalToolDetailsCategory category, InternalToolEnrichDataFetcher fetcher) {
        this.category = category;
        this.extractor = extractor;
        this.fieldName = fieldName;
        this.fetcher = fetcher;
    }

    InternalToolFieldExtractor getExtractor() {
        return extractor;
    }

    InternalToolEnrichDataFetcher getFetcher() {
        return fetcher;
    }

    InternalToolDetailsCategory getCategory() {
        return category;
    }

    public String getFieldName() {
        return fieldName;
    }

    public InternalToolDetailsData fetchDetails(List<?> data) {
        Set<Object> keys = data.stream()
                .map(d -> extractor.getValue(d))
                .collect(Collectors.toSet());
        return new InternalToolDetailsData(category, fetcher.fetch(keys));
    }
}
