package ru.yandex.direct.internaltools.core.enrich;

import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.internaltools.core.util.FieldUtil;

import static ru.yandex.direct.internaltools.core.util.FieldUtil.getExtractor;

@ParametersAreNonnullByDefault
public class InternalToolEnrichProcessorFactory {
    private final Map<InternalToolDetailKey, InternalToolEnrichDataFetcher> keysToFetchers;

    public InternalToolEnrichProcessorFactory(Map<InternalToolDetailKey, InternalToolEnrichDataFetcher> keysToFetchers) {
        this.keysToFetchers = new EnumMap<>(InternalToolDetailKey.class);
        this.keysToFetchers.putAll(keysToFetchers);
    }

    Map<InternalToolDetailKey, InternalToolEnrichDataFetcher> getKeysToFetchers() {
        return keysToFetchers;
    }

    /**
     * Получить объект, который генерирует данные, необходимые для отображения расширенной сущности вместо поля в ответе
     * внутреннего инструмента, для заданного поля в заданном классе.
     * Вернуть null, если такой объект создать невозможно
     */
    @Nullable
    public InternalToolEnrichProcessor forField(Field field, Class<?> cls) {
        Enrich enrichData = field.getAnnotation(Enrich.class);
        if (enrichData == null) {
            return null;
        }
        InternalToolDetailKey key = enrichData.value();

        InternalToolEnrichDataFetcher fetcher = keysToFetchers.get(key);
        if (fetcher == null) {
            return null;
        }
        return new InternalToolEnrichProcessor(FieldUtil.getFieldName(cls, field),
                getExtractor(cls, field, field.getType()), key.getCategory(), keysToFetchers.get(key));
    }
}
