package ru.yandex.direct.internaltools.core.enums;

import java.util.Arrays;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

/**
 * Роли доступа к внутренним отчетам
 * <p>
 * Часть пока закомментирована, так как не поддерживается. Не удаляем, так как роли были в перловой версии
 */
public enum InternalToolAccessRole {
    // SPECIFIC_SUPER_USER,
    SUPER,
    DEVELOPER(SUPER),
    SUPERREADER(DEVELOPER),
    MANAGER(SUPER),
    SUPPORT(SUPER),
    MEDIAPLANNER(SUPER),
    PLACER(SUPER),
    // это админ внутренней рекламы
    INTERNAL_AD_ADMIN(SUPER),
    // это внутренний пользователь -- не обязательно имеет отношение к внутренней рекламе
    INTERNAL_USER(PLACER, MEDIAPLANNER, SUPPORT, MANAGER, SUPERREADER, DEVELOPER, SUPER, INTERNAL_AD_ADMIN);
    // LOG_READER,
    // CATALOG_MODERATOR,

    private final Set<InternalToolAccessRole> parentRoles;

    InternalToolAccessRole(InternalToolAccessRole... parentRoles) {
        this.parentRoles = ImmutableSet.<InternalToolAccessRole>builder().addAll(Arrays.asList(parentRoles)).build();
    }

    public Set<InternalToolAccessRole> getParentRoles() {
        return parentRoles;
    }
}
