package ru.yandex.direct.internaltools.core.enums;

/**
 * Типы ключей, для которых в массовом ответе внутреннего инструмента мы можем поддержать доставку
 * дополнительных данных, необходимых для построения расширенного ответа на фронтенде
 * <p>
 * ВАЖНО: сейчас поддерживаются не все эти ключи. Для поддержки ключа нужно реализовать интерфейс
 * {@link ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher} и разместить реализацию в модуле
 * {@link ru.yandex.direct.internaltools.datafetchers}
 */
public enum InternalToolDetailKey {
    CAMPAIGN_ID(InternalToolDetailsCategory.CAMPAIGN),
    ORDER_ID(InternalToolDetailsCategory.CAMPAIGN),
    USER_ID(InternalToolDetailsCategory.USER),
    LOGIN(InternalToolDetailsCategory.USER),
    CLIENT_ID(InternalToolDetailsCategory.USER),
    AGENCY_LOGIN(InternalToolDetailsCategory.AGENCY),
    BANNER_ID(InternalToolDetailsCategory.BANNER),
    BS_BANNER_ID(InternalToolDetailsCategory.BANNER),
    KEYWORD_ID(InternalToolDetailsCategory.KEYWORD),
    BS_KEYWORD_ID(InternalToolDetailsCategory.KEYWORD),
    GEO(InternalToolDetailsCategory.GEO),
    FIRM(InternalToolDetailsCategory.FIRM),
    COUNTRY(InternalToolDetailsCategory.COUNTRY),
    BOOLEAN_REPLACE(InternalToolDetailsCategory.COMMON_REPLACE),
    BOOLEAN_MARKS_REPLACE(InternalToolDetailsCategory.COMMON_REPLACE),
    IP_WHOIS_LINK_REPLACE(InternalToolDetailsCategory.LINK_REPLACE),
    LOGIN_CLIENT_CAMPAIGNS_LINK_REPLACE(InternalToolDetailsCategory.CLIENT_CAMPAIGNS_LINK_REPLACE),
    FIO_CLIENT_CAMPAIGNS_LINK_REPLACE(InternalToolDetailsCategory.CLIENT_CAMPAIGNS_LINK_REPLACE),
    COMMON_LINK_REPLACE(InternalToolDetailsCategory.LINK_REPLACE),
    STARTREK_TICKET_LINK_REPLACE(InternalToolDetailsCategory.LINK_REPLACE),
    STARTREK_ONESHOT_TICKET_LINK_REPLACE(InternalToolDetailsCategory.LINK_REPLACE),
    ARCADIA_LINK_NAME_REPLACE(InternalToolDetailsCategory.LINK_NAME_REPLACE),
    LOGVIEWER_LINK_NAME_REPLACE(InternalToolDetailsCategory.LINK_NAME_REPLACE),
    HIGHLIGHT(InternalToolDetailsCategory.HIGHLIGHT),
    JSON_PRETTIFY(InternalToolDetailsCategory.JSON_PRETTIFY),
    HTML_PRETTIFY(InternalToolDetailsCategory.HTML_PRETTIFY),
    DIFF(InternalToolDetailsCategory.DIFF),
    ABT_TESTID_LINK(InternalToolDetailsCategory.LINK_REPLACE),
    ESS_LOGIC_OBJECTS_LINK(InternalToolDetailsCategory.LINK_REPLACE),
    EXPANDER(InternalToolDetailsCategory.EXPANDER);

    private InternalToolDetailsCategory category;

    InternalToolDetailKey(InternalToolDetailsCategory category) {
        this.category = category;
    }

    public InternalToolDetailsCategory getCategory() {
        return category;
    }
}
