package ru.yandex.direct.internaltools.core.implementations;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public abstract class MassInternalTool<T extends InternalToolParameter, R> implements BaseInternalTool<T> {
    @Override
    public final InternalToolMassResult<R> process(T parameter) {
        return new InternalToolMassResult<>(getMassData(parameter));
    }

    @Override
    public final InternalToolMassResult<R> processWithoutInput() {
        List<R> data = getMassData();
        if (data == null || data.isEmpty()) {
            return null;
        }
        return new InternalToolMassResult<>(data);
    }

    @Nullable
    protected List<R> getMassData() {
        return null;
    }

    protected abstract List<R> getMassData(T parameter);
}
