package ru.yandex.direct.internaltools.core.implementations;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public abstract class MassInternalToolWithoutParam<T> implements BaseInternalTool<InternalToolParameter> {
    @Override
    public final InternalToolMassResult<T> process(InternalToolParameter parameter) {
        return processWithoutInput();
    }

    @Override
    public InternalToolMassResult<T> processWithoutInput() {
        return new InternalToolMassResult<>(getMassData());
    }

    protected abstract List<T> getMassData();
}
