package ru.yandex.direct.internaltools.core.input;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Группа полей ввода. Предполагается, что интерфейс будет отбражать поля ввода по группам, отделяя друг от друга
 */
@ParametersAreNonnullByDefault
public class InternalToolInputGroup<T extends InternalToolParameter> {
    private final String name;
    private final int priority;
    private final List<InternalToolInput<T, ?>> inputList;

    public InternalToolInputGroup(String name, int priority) {
        this(name, priority, Collections.emptyList());
    }

    public InternalToolInputGroup(String name, int priority,
                                  List<InternalToolInput<T, ?>> inputList) {
        this.name = name;
        this.priority = priority;
        this.inputList = inputList;
    }

    public String getName() {
        return name;
    }

    public int getPriority() {
        return priority;
    }

    public void addValidation(ItemValidationBuilder<T, Defect> validationBuilder, T param) {
        inputList.forEach(i -> i.addValidation(validationBuilder, param));
    }

    public List<InternalToolInput<T, ?>> getInputList() {
        return mapList(inputList, InternalToolInput::applyPreProcessors);
    }

    public List<InternalToolInput<T, ?>> getInputListWithoutPreprocessing() {
        return inputList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalToolInputGroup<?> group = (InternalToolInputGroup<?>) o;
        return priority == group.priority &&
                Objects.equals(name, group.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, priority);
    }
}
