package ru.yandex.direct.internaltools.core.input;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

/**
 * Обработчик описаний полей ввода
 *
 * @param <D> тип данных поля ввода
 */
public interface InternalToolInputPreProcessor<D> {
    /**
     * Выполнить преобразования над билдером описания поля ввода, если это нужно.
     * Вызывается только один раз перед тем как обертка будет создана и добавлена в каталог инструментов.
     *
     * @param inputBuilder полностью заполненный билдер описания поля ввода
     * @return новый экземпляр билдера и модифицированный переданный билдер
     */
    default <T extends InternalToolParameter> InternalToolInput.Builder<T, D> preCreate(
            InternalToolInput.Builder<T, D> inputBuilder) {
        return inputBuilder;
    }

    /**
     * Выполнить преобразования над билдером описания поля ввода, если это нужно.
     * Вызывается каждый раз перед тем, как описание поля ввода будет отдано клиенту.
     *
     * @param inputBuilder полностью заполненный билдер описания поля ввода
     * @return новый экземпляр билдера и модифицированный переданный билдер
     */
    default <T extends InternalToolParameter> InternalToolInput.Builder<T, D> preSend(
            InternalToolInput.Builder<T, D> inputBuilder) {
        return inputBuilder;
    }

    /**
     * Выполнить преобразования над билдером описания поля ввода, если это нужно.
     * Вызывается каждый раз перед тем, как описание поля ввода будет использовано для валидации полученного от клиента
     * ввода. По умолчанию ничем не отличается от preSend
     *
     * @param inputBuilder полностью заполненный билдер описания поля ввода
     * @return новый экземпляр билдера и модифицированный переданный билдер
     */
    default <T extends InternalToolParameter> InternalToolInput.Builder<T, D> preReceive(
            InternalToolInput.Builder<T, D> inputBuilder) {
        return preSend(inputBuilder);
    }
}
