package ru.yandex.direct.internaltools.core.input.processors;

import java.time.LocalDate;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

public class CurrentDatePreProcessor implements InternalToolInputPreProcessor<LocalDate> {
    public static final CurrentDatePreProcessor DEFAULT = new CurrentDatePreProcessor();

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, LocalDate> preSend(
            InternalToolInput.Builder<T, LocalDate> inputBuilder) {
        return inputBuilder
                .withDefaultValue(LocalDate.now());
    }
}
