package ru.yandex.direct.internaltools.core.input.processors;

import java.time.LocalDateTime;
import java.util.function.Function;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

public class CurrentDateTimePreProcessor implements InternalToolInputPreProcessor<LocalDateTime> {
    public static final CurrentDateTimePreProcessor DEFAULT = new CurrentDateTimePreProcessor(Function.identity());

    private final Function<LocalDateTime, LocalDateTime> timeShifter;

    public CurrentDateTimePreProcessor(Function<LocalDateTime, LocalDateTime> timeShifter) {
        this.timeShifter = timeShifter;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, LocalDateTime> preSend(
            InternalToolInput.Builder<T, LocalDateTime> inputBuilder) {
        return inputBuilder
                .withDefaultValue(timeShifter.apply(LocalDateTime.now()));
    }
}
