package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@EnrichFetcher(InternalToolDetailKey.ABT_TESTID_LINK)
@ParametersAreNonnullByDefault
public class AbtTestLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    private static final String AB_TEST_ID_BASE_URL = "https://ab.yandex-team.ru/testid/";

    @Override
    public Map<String, String> fetch(Collection<String> testIds) {
        return StreamEx.of(testIds)
                .filter(testId -> testId != null && !testId.isEmpty())
                .mapToEntry(testId -> AB_TEST_ID_BASE_URL + testId)
                .toMap();
    }
}
