package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@EnrichFetcher(InternalToolDetailKey.ARCADIA_LINK_NAME_REPLACE)
@ParametersAreNonnullByDefault
public class ArcanumLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    @Override
    public Map<String, String> fetch(Collection<String> urls) {
        return StreamEx.of(urls)
                .filter(url -> url != null && !url.isEmpty())
                .mapToEntry(url -> "Открыть в Arcanum (" + url.substring(url.lastIndexOf('/') + 1) + ")")
                .toMap();
    }
}
