package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Enrich fetcher, который может быть использован с Boolean полями.
 * При его использовании в таблице с результатами булевые значения будут заменены на юникодные значки
 * BooleanMarksFetcher.TRUE_MARK (галочка) и BooleanMarksFetcher.FALSE_MARK (крестик).
 * Реализация замены в /direct/web/src/main/resources/webapp/static/internaltools/result.jsx
 */
@EnrichFetcher(InternalToolDetailKey.BOOLEAN_MARKS_REPLACE)
@ParametersAreNonnullByDefault
public class BooleanMarksFetcher implements InternalToolEnrichDataFetcher<Boolean, String> {

    private static final String TRUE_MARK = "\u2705";
    private static final String FALSE_MARK = "\u274C";

    @Override
    public Map<Boolean, String> fetch(Collection<Boolean> keys) {
        return StreamEx.of(keys)
                .mapToEntry(aBoolean -> aBoolean ? TRUE_MARK : FALSE_MARK)
                .toMap();
    }
}
