package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@EnrichFetcher(InternalToolDetailKey.COMMON_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class CommonLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    @Override
    public Map<String, String> fetch(Collection<String> urls) {
        return listToMap(urls, Function.identity());
    }
}
