package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@EnrichFetcher(InternalToolDetailKey.DIFF)
@ParametersAreNonnullByDefault
public class DiffBlockFetcher implements InternalToolEnrichDataFetcher<String, String> {
    @Override
    public Map<String, String> fetch(Collection<String> keys) {
        // Все что угодно, форматируем код безусловно по наличию details.category = DIFF
        // см. direct/web/src/main/resources/webapp/static/internaltools/result.jsx
        return Map.of("prettify", "true");
    }
}
