package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.internaltools.core.enums.InternalToolProcessingResult;

/**
 * Enrich fetcher, который используется для подсветки стандартных результатов выполнения (InternalToolProcessingResult)
 * Сейчас все значения, отличные от InternalToolProcessingResult.OK, трактуются как ошибка и подсвечиваются красным.
 */
@EnrichFetcher(InternalToolDetailKey.HIGHLIGHT)
@ParametersAreNonnullByDefault
public class HighLightFetcher implements InternalToolEnrichDataFetcher<InternalToolProcessingResult, String> {

    private static final String RED = "red";
    private static final String GREEN = "green";

    @Override
    public Map<InternalToolProcessingResult, String> fetch(Collection<InternalToolProcessingResult> keys) {
        return StreamEx.of(keys)
                .mapToEntry(res -> (res == InternalToolProcessingResult.OK) ? GREEN : RED)
                .toMap();
    }
}
