package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.internaltools.utils.InternalToolUtils;

/**
 * Enrich fetcher, который может быть использован с String полями.
 * При его использовании в таблице с результатами значения
 * будут заменены на ссылки на WHOIS.
 * Реализация замены в /direct/web/src/main/resources/webapp/static/internaltools/result.jsx
 */
@EnrichFetcher(InternalToolDetailKey.IP_WHOIS_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class IpWhoisLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    private final String whoisUrl;

    public IpWhoisLinkFetcher(@Value("${internal_tools.whoisUrl}") String whoisUrl) {
        this.whoisUrl = whoisUrl;
    }

    @Override
    public Map<String, String> fetch(Collection<String> ips) {
        return StreamEx.of(ips)
                .mapToEntry(ip -> (InternalToolUtils.wrapWithHidereferrer(whoisUrl + ip)))
                .toMap();
    }
}
