package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Enrich fetcher, который может быть использован с String полями — login'ами клиентов.
 * При его использовании в таблице с результатами значения
 * будут заменены на логины — ссылки страницу кампаний клиентов.
 * Реализация замены в /direct/web/src/main/resources/webapp/static/internaltools/result.jsx
 */
@EnrichFetcher(InternalToolDetailKey.LOGIN_CLIENT_CAMPAIGNS_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class LoginClientCampaignsLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    @Override
    public Map<String, String> fetch(Collection<String> logins) {
        return StreamEx.of(logins).mapToEntry(login -> login, login -> login).toMap();
    }
}
