package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Enrich fetcher, который может быть использован с String полями — login'ами клиентов.
 * При его использовании в таблице с результатами значения
 * будут заменены на ФИО — ссылки страницу кампаний клиентов.
 * Реализация замены в /direct/web/src/main/resources/webapp/static/internaltools/result.jsx
 */
@EnrichFetcher(InternalToolDetailKey.FIO_CLIENT_CAMPAIGNS_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class NameClientCampaignsLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    private final UserService userService;

    public NameClientCampaignsLinkFetcher(UserService userService) {
        this.userService = userService;
    }

    @Override
    public Map<String, String> fetch(Collection<String> logins) {
        Collection<User> users = userService.massGetUserByLogin(logins);
        return StreamEx.of(users).mapToEntry(User::getLogin, User::getFio).toMap();
    }
}
