package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;
import ru.yandex.direct.oneshot.core.entity.oneshot.service.OneshotStartrekService;

/**
 * Ваншот специфичная версия StartrekTicketLinkFetcher, из-за того, что урл зависит от окружения
 */
@EnrichFetcher(InternalToolDetailKey.STARTREK_ONESHOT_TICKET_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class StartrekOneshotTicketLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    private final OneshotStartrekService oneshotStartrekService;

    public StartrekOneshotTicketLinkFetcher(OneshotStartrekService oneshotStartrekService) {
        this.oneshotStartrekService = oneshotStartrekService;
    }

    @Override
    public Map<String, String> fetch(Collection<String> tickets) {
        return StreamEx.of(tickets)
                .filter(ticket -> ticket != null && !ticket.isEmpty())
                .mapToEntry(oneshotStartrekService::getTicketUrl)
                .toMap();
    }
}
